<?php

namespace Fivable\Buildable\Policies;

use App\User;
use Fivable\Buildable\Models\BuildablePost;
use Illuminate\Auth\Access\HandlesAuthorization;

class BuildablePostPolicy
{
    use HandlesAuthorization;

    /**
     * Determine whether the user can view the buildable post.
     *
     * @param  User  $user
     * @return bool
     */
    public function viewIndex(User $user) : bool
    {
        return true;
    }
    
    /**
     * Determine whether the user can view the buildable post.
     *
     * @param  User  $user
     * @param  BuildablePost  $buildablePost
     * @return bool
     */
    public function view(User $user, BuildablePost $buildablePost) : bool
    {
        return true;
    }

    /**
     * Determine whether the user can create buildable posts.
     *
     * @param  User  $user
     * @return bool
     */
    public function create(User $user) : bool
    {
        return true;
    }

    /**
     * Determine whether the user can update the buildable post.
     *
     * @param  User  $user
     * @param  BuildablePost  $buildablePost
     * @return bool
     */
    public function update(User $user, BuildablePost $buildablePost) : bool
    {
        return true;
    }

    /**
     * Determine whether the user can delete the buildable post.
     *
     * @param  User  $user
     * @param  BuildablePost  $buildablePost
     * @return bool
     */
    public function delete(User $user, BuildablePost $buildablePost) : bool
    {
        return true;
    }
}
