<?php

namespace Fivable\Buildable\Policies;

use App\User;
use Fivable\Buildable\Models\BuildableComponent;
use Illuminate\Auth\Access\HandlesAuthorization;

class BuildableComponentPolicy
{
    use HandlesAuthorization;

    /**
     * Determine whether the User can view the BuildableComponent
     * @param  User  $user
     * @param  BuildableComponent  $buildableComponent
     * @return bool
     */
    public function view(User $user, BuildableComponent $buildableComponent) : bool
    {
        return true;
    }

    /**
     * Determine whether the User can create a BuildableComponent
     * @param  User  $user
     * @return bool
     */
    public function create(User $user) : bool
    {
        return true;
    }

    /**
     * Determine whether the User can update the BuildableComponent
     * @param  User  $user
     * @param  BuildableComponent  $buildableComponent
     * @return bool
     */
    public function update(User $user, BuildableComponent $buildableComponent) : bool
    {
        return true;
    }

    /**
     * Determine whether the user can delete a specific BuildableComponent
     * @param  User  $user
     * @param  BuildableComponent  $buildableComponent
     * @return bool
     */
    public function delete(User $user, BuildableComponent $buildableComponent) : bool
    {
        return true;
    }
}
