<?php

namespace Fivable\Buildable\Models;

Use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class BuildableFileMeta extends Model
{
    /* Columns that are mass-assignable */
    protected $fillable = ['buildable_file_id', 'key', 'value'];


    /** Relationships
     * ----------------*/

    /**
     * Get the BuildableFile this BuildableFileMeta is associated with
     * @return BelongsTo
     */
    public function buildable_file()
    {
        return $this->belongsTo('Fivable\Buildable\Models\BuildableFile');
    }
}
