<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateBuildablePostBuildableTagTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('buildable_post_buildable_tag', function (Blueprint $table) {
            $table->integer('buildable_post_id')->unsigned();
            $table->integer('buildable_tag_id')->unsigned();
            $table->timestamps();
            $table->softDeletes();

            $table->primary(['buildable_post_id', 'buildable_tag_id'], 'post_tag_composite');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('buildable_post_buildable_tag');
    }
}
