<?php

namespace Fivable\Buildable\Commands;

use Fivable\Buildable\Models\BuildableSetting;
use Illuminate\Console\Command;
use Symfony\Component\Process\Exception\ProcessFailedException;
use Symfony\Component\Process\Process;

class RewriteVariables extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'rewrite:variables';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Rewrite sass variables based on settings';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return mixed
     */
    public function handle()
    {
        $settingsCollection = BuildableSetting::indexFor(1);
        $settings = [];
        foreach ($settingsCollection as $setting) {
            $settings[$setting->slug] = $setting->value;
        }

        $mobile_header_height = 0; // TODO: fix this later, is supposed to be real setting
        $header_opacity = (($settings['header-options'] == 'fixed-height') ? 1 : ((!empty($settings['header-opacity'])) ? str_replace('%', '', $settings['header-opacity']) : 0));

        $header_opacity = ($header_opacity > 1) ? $header_opacity / 100 : $header_opacity;

        $scss = '$null: null;' . "\n" . '$black: black;' . "\n" . '$white: white;' . "\n" . '$light: white;' . "\n" . '$dark: black;' . "\n";
        $scss .= '$dark-gray: #1D1D1D; $light-gray: #F1F1F1; $mid-gray: #878787; $shadow-gray: #E0E0DC; $subfooter-height: 40;' . "\n";
        $scss .= '$font-size-multiplier: ' . $settings['font-size-multiplier'] . "; \n";
        $scss .= '$header-font-family: "' . $settings['header-font-family'] . '";' . "\n";
        $scss .= '$body-font-family: "' . $settings['body-font-family'] . '";' . "\n";
        $scss .= '$primary-color: ' . $settings['primary-color'] . ";\n";
        $scss .= '$secondary-color: ' . $settings['secondary-color'] . ";\n";
        $scss .= '$tertiary-color: ' . $settings['tertiary-color'] . ";\n";
        $scss .= '$quaternary-color: ' . $settings['quaternary-color'] . ";\n";
        $scss .= '$quinary-color: ' . $settings['quinary-color'] . ";\n";
        $scss .= '$header-color: $' . $settings['header-color'] . ";\n";
        $scss .= '$header-link-color: $' . $settings['header-link-color'] . ";\n";
        $scss .= '$header-button-color: $' . $settings['header-button-color'] . ";\n";
        $scss .= '$header-subnav-color: $' . $settings['header-sub-nav-color'] . ";\n";
        $scss .= '$header-subnav-accent-color: $' . $settings['header-sub-nav-accent-color'] . ";\n";
        $scss .= '$header-subnav-link-color: $' . $settings['header-sub-nav-link-color'] . ";\n";
        $scss .= '$header-opacity: ' . $header_opacity . ";\n";
        $scss .= '$header-height: ' . $settings['header-height'] . ";\n";
        $scss .= '$mobile-header-height: ' . $mobile_header_height . ";\n";
        $scss .= '$footer-height: ' . $settings['footer-height'] . ";\n";
        $scss .= '$footer-color: $' . $settings['footer-color'] . ";\n";
        $scss .= '$subfooter-color: $' . $settings['sub-footer-color'] . ";\n";
        $scss .= '$base-font-size: 18px;' . "\n";
        $scss .= '$mobile-base-font-size: 18px;' . "\n";
        $scss .= '$h1-font-size: 48px;' . "\n";
        $scss .= '$h2-font-size: 36px;' . "\n";
        $scss .= '$h3-font-size: 30px;' . "\n";
        $scss .= '$h4-font-size: 24px;' . "\n";
        $scss .= '$h5-font-size: 20px;' . "\n";
        $scss .= '$h6-font-size: 20px;' . "\n";
        $scss .= '$mobile-h1-font-size: 36px;' . "\n";
        $scss .= '$mobile-h2-font-size: 28px;' . "\n";
        $scss .= '$mobile-h3-font-size: 24px;' . "\n";
        $scss .= '$mobile-h4-font-size: 20px;' . "\n";
        $scss .= '$mobile-h5-font-size: 18px;' . "\n";
        $scss .= '$mobile-h6-font-size: 18px;' . "\n";
        $scss .= '$negative-margin: -80;' . "\n";
        $scss .= '$mobile-negative-margin: -40;' . "\n";
        $scss .= '$background-angle: ' . config('buildable.background-angle') . ';' . "\n";

        file_put_contents(resource_path('assets/vendor/buildable/sass/assets/_variables.scss'), $scss);

        if (env('APP_ENV') == 'production') {
//            $yarnCommand = '(cd .. && yarn run prod 2>&1)';
            $yarnCommand = '(cd .. && node node_modules/cross-env/dist/bin/cross-env.js NODE_ENV=production node_modules/webpack/bin/webpack.js --no-progress --hide-modules --config=node_modules/laravel-mix/setup/webpack.config.js --verbose 2>&1)';
        } else {
//            $yarnCommand = '(cd .. && yarn run dev 2>&1)';
            $yarnCommand = '(cd .. && node node_modules/cross-env/dist/bin/cross-env.js NODE_ENV=development node_modules/webpack/bin/webpack.js --progress --hide-modules --config=node_modules/laravel-mix/setup/webpack.config.js --verbose 2>&1)';
        }

//        $process = new Process($yarnCommand);
//        $process->run();
//
//        if (!$process->isSuccessful()) {
//            throw new ProcessFailedException($process);
//        }
//        \Log::info($process->getOutput());

        $echo = shell_exec($yarnCommand);
        \Log::info($echo);

//        $variables = '{ "black": "#000000",' . "\n" . '"light": "#FFFFFF",' . "\n" . '"dark": "#000000",' . "\n";
//        $variables .= '"dark-gray": "#1D1D1D",' . "\n" . ' "light-gray": "#F1F1F1",' . "\n" . ' "mid-gray": "#878787",' . "\n";
//        $variables .= '"primary-color": "' . $settings["primary_color"] . '"' . ",\n";
//        $variables .= '"secondary-color": "' . $settings["secondary_color"] . '"' . ",\n";
//        $variables .= '"tertiary-color": "' . $settings["tertiary_color"] . '"' . ",\n";
//        $variables .= '"quaternary-color": "' . $settings["quaternary_color"] . '"' . ",\n";
//        $variables .= '"quinary-color": "' . $settings["quinary_color"] . '"' . " }\n";
//
//        file_put_contents($variables_json_file, $variables);
    }
}
